<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 04.12.13 14:41
 */

namespace VM\PackageGeneratorBundle\Services\Export;


class StructureJson extends AbstractStructure implements StructureInterface
{
    /**
     * @var array
     */
    protected  $structure = array();

    public function get($path, $authCode, $title = '')
    {
        $this->addSettingsSection($authCode, $title);
        $this->addToolbarsSection();
        $this->addOtherOptions();
        $this->addContentSection($path);

        return json_encode($this->structure);
    }


    protected function addSettingsSection($authCode, $title)
    {
        $this->structure['settings'] = array(
            'flipbook_id' => 'test',
            'flipbook_ver' => 1,
            'product_id' => '001',
            'title' => $title,
            'productCode' => $authCode
        );
    }

    protected function addToolbarsSection()
    {
        $this->structure['extra_toolbars'] = array(
            '-type' => 'file',
            '-interactions' => array(
                '-type' => 'file',
                '#text' => 'otherXmls/interactionsToolbar.json'
            )
        );
    }

    protected function addOtherOptions()
    {
        $this->structure['interactions'] = array(
            '-type' => 'file',
            '#text' => 'otherXmls/interactions.json'
        );

        $this->structure['about'] = 'otherXmls/about.json';
        $this->structure['logo'] = 'logo.png';
    }


    protected function addContentSection($path)
    {
        $files = $this->getSortedListOfFiles($path);
        $size = getimagesize($path . '/' . $files[0]);

        $content = array(
            '-first_spread' => 1,
            '-firstPageSingle' => true,
            '-arrows_pos' => 'top',
            '-v_margin' => 67,
            '-h_margin' => 30,
            '-frame' => 4,
            '-toolbar-width' => 35,
            'page_size' => array(
                '-width' => $this->pageWidth,
                '-height' => $this->pageHeight
            ),
            'pages' => array()
        );


        $i = 1;
        foreach($files as $filename)
        {
            $content['pages'][] = array(
                '-id' => $i,
                '-number' => $i,
                'pagePath' => 'pages/' . $filename,
                'preview' => 'pages/' . $filename,
                'interactionsPath' => ''
            );
            $i++;
        }

        $this->structure['content'] = $content;
    }

} 